<?php
/**
 * Add Password Column to Staff Table
 * Run this if password column is missing from existing staff table
 */

$host = 'localhost';
$user = 'root';
$pass = '';
$db = 'cleaning_service';

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if password column exists
$checkColumn = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS 
                WHERE TABLE_NAME = 'staff' AND COLUMN_NAME = 'password' AND TABLE_SCHEMA = '$db'";
$result = $conn->query($checkColumn);

if ($result && $result->num_rows > 0) {
    echo "<div style='padding: 20px; background: #d4edda; color: #155724; border-radius: 5px; margin: 20px;'>";
    echo "<strong>✓ Password column already exists in staff table</strong>";
    echo "</div>";
} else {
    // Add password column
    $alterTable = "ALTER TABLE staff ADD COLUMN password VARCHAR(255) NOT NULL AFTER position";
    
    if ($conn->query($alterTable)) {
        echo "<div style='padding: 20px; background: #d4edda; color: #155724; border-radius: 5px; margin: 20px;'>";
        echo "<strong>✓ Password column added successfully to staff table</strong>";
        echo "</div>";
    } else {
        echo "<div style='padding: 20px; background: #f8d7da; color: #721c24; border-radius: 5px; margin: 20px;'>";
        echo "<strong>✗ Error adding password column: " . $conn->error . "</strong>";
        echo "</div>";
    }
}

// Verify the column now exists
$verifyColumn = "SELECT COLUMN_NAME, COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS 
                 WHERE TABLE_NAME = 'staff' AND COLUMN_NAME = 'password' AND TABLE_SCHEMA = '$db'";
$verifyResult = $conn->query($verifyColumn);

if ($verifyResult && $verifyResult->num_rows > 0) {
    $row = $verifyResult->fetch_assoc();
    echo "<div style='padding: 20px; background: #cfe2ff; color: #084298; border-radius: 5px; margin: 20px;'>";
    echo "<strong>Database Status:</strong><br>";
    echo "Column Name: " . htmlspecialchars($row['COLUMN_NAME']) . "<br>";
    echo "Column Type: " . htmlspecialchars($row['COLUMN_TYPE']) . "<br>";
    echo "<br>Staff table is now ready for password management!";
    echo "</div>";
} else {
    echo "<div style='padding: 20px; background: #f8d7da; color: #721c24; border-radius: 5px; margin: 20px;'>";
    echo "<strong>✗ Password column verification failed</strong>";
    echo "</div>";
}

$conn->close();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Database Migration - Staff Password Column</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f8fbff, #f1f5f4);
            padding: 40px 20px;
            margin: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #109c3d;
            text-align: center;
            margin-top: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔐 Staff Password Migration</h1>
        <?php echo "<!-- Migration completed -->"; ?>
    </div>
</body>
</html>
